﻿/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件主要针对箱体进行操作，包括发送模组、箱体连接、常规参数、寄存器、gama、矫正、控制命令等
 *   信息，在MVC中，它处理ctrl层，依赖于modle（数据）层的模组、箱体连接、参数json等
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 张启丰
 *      时间 : 2020.04.16
 *      内容 : 创建框架结构
 *************************************************************************************************/

/* exported  mc_dispchip_reg_info*/
/* global  $*/
/* global  mc_sdk_param*/

/************************************************************************************************
* 类型:
*    构造函数
* 功能:
*    请求显示芯片注册信息,通过对应方法获取注册信息中的对应内容
* 参数:
*    NA
* 返回：
*    NA
* 例子：
*    NA
* 备注：
*    可设置注册信息
* 修改:
*   1. 类型 : 创建
*      作者 : 张启丰,徐烁超,李智明
*      时间 : 2020.4.16
************************************************************************************************/
function mc_dispchip_reg_info() {
    var m_str_dispchip_name = "";
    var m_str_ctrlchip_name = "";
    var obj_ui_param = new mc_sdk_param();
    // 跳点标识
    var m_b_jump_ic = false;
    // 跳点值
    var m_ui_pix_step = 1;
    // IGNORE_OE
    var m_ui_ignore_oe = 0;
    // IGNORE_TX
    var m_ui_ignore_tx = 0;
    // MAX_SCAN_ROWS
    var m_ui_max_scan_rouws = 0;
    // MAX_STR_SIZE
    var m_ui_max_str_size = 0;
    // PWM_IC
    var m_ui_pwm_ic = 0;
    // info_json
    var m_str_info_json = "";

    //获取注册信息状态
    var b_status = false;

    //储存未返回时请求内容的回调函数
    var ary_get_info_json = [];
    var ary_get_pix_step = [];
    var ary_get_jump_ic = [];
    var ary_get_ignore_oe = [];
    var ary_get_ignore_tx = [];
    var ary_get_max_scan_rouws = [];
    var ary_get_max_str_size = [];
    var ary_get_pwm_ic = [];

    this.set_chip_name = function (str_dispchip, str_ctrlchip) {
        // if ( m_str_dispchip_name === str_dispchip && m_str_ctrlchip_name === str_ctrlchip) {
        //     return;
        // }
        m_str_dispchip_name = str_dispchip;
        m_str_ctrlchip_name = str_ctrlchip;
        b_status = false;

        obj_ui_param.set_param_clear();
        obj_ui_param.set_cmd("GET_PARAM");
        obj_ui_param.set_func("DISPCHIP_INFO");
        obj_ui_param.set_param_value(str_dispchip, "");
        if ("string" === typeof str_ctrlchip && 0 < str_ctrlchip.length) {
            obj_ui_param.set_attr_val(str_dispchip, "CTRLCHIP", str_ctrlchip);
        }

        $.post("/access_shell", obj_ui_param.get_json(), function (response) {
            //将状态设置为成功
            b_status = true;

            obj_ui_param.set_param_clear();
            obj_ui_param.set_json(response);

            m_b_jump_ic = obj_ui_param.get_attr_val(str_dispchip, "JUMP_IC");
            if (0 === Number(m_b_jump_ic)) {
                m_b_jump_ic = false;
            } else {
                m_b_jump_ic = true;
            }
            m_ui_pix_step = obj_ui_param.get_attr_val(str_dispchip, "IC_CHANNELS");
            m_ui_ignore_oe = obj_ui_param.get_attr_val(str_dispchip, "IGNORE_OE");
            m_ui_ignore_tx = obj_ui_param.get_attr_val(str_dispchip, "IGNORE_TX");
            m_ui_max_scan_rouws = obj_ui_param.get_attr_val(str_dispchip, "MAX_SCAN_ROWS");
            m_ui_max_str_size = obj_ui_param.get_attr_val(str_dispchip, "MAX_STR_SIZE");
            m_ui_pwm_ic = obj_ui_param.get_attr_val(str_dispchip, "PWM_IC");
            m_str_info_json = response;

            for (var idx_pix_step = 0; idx_pix_step < ary_get_pix_step.length; idx_pix_step++) {
                ary_get_pix_step[idx_pix_step](m_ui_pix_step);
            }
            ary_get_pix_step = [];
            for (var idx_jump = 0; idx_jump < ary_get_jump_ic.length; idx_jump++) {
                ary_get_jump_ic[idx_jump](m_b_jump_ic);
            }
            ary_get_jump_ic = [];
            for (var idx_oe = 0; idx_oe < ary_get_ignore_oe.length; idx_oe++) {
                ary_get_ignore_oe[idx_oe](m_ui_ignore_oe);
            }
            ary_get_ignore_oe = [];
            for (var idx_tx = 0; idx_tx < ary_get_ignore_tx.length; idx_tx++) {
                ary_get_ignore_tx[idx_tx](m_ui_ignore_tx);
            }
            ary_get_ignore_tx = [];
            for (var idx_rows = 0; idx_rows < ary_get_max_scan_rouws.length; idx_rows++) {
                ary_get_max_scan_rouws[idx_rows](m_ui_max_scan_rouws);
            }
            ary_get_max_scan_rouws = [];
            for (var idx_size = 0; idx_size < ary_get_max_str_size.length; idx_size++) {
                ary_get_max_str_size[idx_size](m_ui_max_str_size);
            }
            ary_get_max_str_size = [];
            for (var idx_pwm = 0; idx_pwm < ary_get_pwm_ic.length; idx_pwm++) {
                ary_get_pwm_ic[idx_pwm](m_ui_pwm_ic);
            }
            ary_get_pwm_ic = [];
            for (var idx = 0; idx < ary_get_info_json.length; idx++) {
                ary_get_info_json[idx](m_str_info_json);
            }
            ary_get_info_json = [];
        });
    };

    /* **************** API **************************** */

    /**
     * @param {Function} fn_callback pix_step
     */
    this.get_pix_step = function (fn_callback) {
        if (!b_status) {
            ary_get_pix_step.push(fn_callback);
            return;
        }
        fn_callback(m_ui_pix_step);
        return;
    };
    /**
     * @param {Function} fn_callback jump_ic
     */
    this.get_jump_ic = function (fn_callback) {
        if (!b_status) {
            ary_get_jump_ic.push(fn_callback);
            return;
        }
        fn_callback(m_b_jump_ic);
        return;
    };
    /**
     * @param {Function} fn_callback ignore_oe
     */
    this.get_ignore_oe = function (fn_callback) {
        if (!b_status) {
            ary_get_ignore_oe.push(fn_callback);
            return;
        }
        fn_callback(m_ui_ignore_oe);
        return;
    };
    /**
     * @param {Function} fn_callback ignore_tx
     */
    this.get_ignore_tx = function (fn_callback) {
        if (!b_status) {
            ary_get_ignore_tx.push(fn_callback);
            return;
        }
        fn_callback(m_ui_ignore_tx);
        return;
    };
    /**
     * @param {Function} fn_callback max_scan_rouws
     */
    this.get_max_scan_rouws = function (fn_callback) {
        if (!b_status) {
            ary_get_max_scan_rouws.push(fn_callback);
            return;
        }
        fn_callback(m_ui_max_scan_rouws);
        return;
    };
    /**
     * @param {Function} fn_callback max_str_size
     */
    this.get_max_str_size = function (fn_callback) {
        if (!b_status) {
            ary_get_max_str_size.push(fn_callback);
            return;
        }
        fn_callback(m_ui_max_str_size);
        return;
    };
    /**
     * @param {Function} fn_callback pwm_ic
     */
    this.get_pwm_ic = function (fn_callback) {
        if (!b_status) {
            ary_get_pwm_ic.push(fn_callback);
            return;
        }
        fn_callback(m_ui_pwm_ic);
        return;
    };
    /**
     * @param {Function} fn_callback info_json
     */
    this.get_info_json = function (fn_callback) {
        if (!b_status) {
            ary_get_info_json.push(fn_callback);
            return;
        }
        fn_callback(m_str_info_json);
        return;
    };
    /**
     * @param {string} str_data json串
     * @return {Boolean} true/false 返回值
     */
    this.set_info_json = function (str_data) {
        if (!str_data) {
            return false;
        }
        b_status = true;
        m_str_info_json = str_data;
        return true;
    };
    /**
     * @param {Array} ary_parm 修改属性 [[name,val],...]
     * @returns {String} 使用指定值的注册信息. 此操作不影响内存本身的值,仅制作一条指定信息,不修改任何内存
     */
    this.get_assign_info_json = function (ary_parm) {
        if (!Array.isArray(ary_parm) || 0 >= ary_parm.length) {
            return m_str_info_json;
        }
        for (var idx_param = 0; idx_param < ary_parm.length; idx_param++) {
            var str_assign_name = ary_parm[idx_param][0];
            var str_assign_val = ary_parm[idx_param][1];

            if (!str_assign_name || !str_assign_val) {
                continue;
            }
            obj_ui_param.set_attr_val(m_str_dispchip_name, str_assign_name, str_assign_val);
        }
        var str_return = obj_ui_param.get_json();

        obj_ui_param.set_json(m_str_info_json);
        return str_return;
    };
}

/************************************************************************************************
* 类型:
*    函数
* 功能:
*    判断两个mc_sdk_param对象生成的子串内容是否相同(只判断值,子属性不判断)
* 参数:
*    @param {promises<String>} str_param_json_new mc_sdk_param描述字串(常规,寄存器,寄存器列表)
*    @param {promises<String>} str_param_json_old mc_sdk_param描述字串(常规,寄存器,寄存器列表)
* 返回：
*    @returns {promises<Boolean>} 两个子串内容是否相同(只考虑名称和内容,不考虑附加属性)
* 例子：
*    NA
* 备注：
*    NA
* 修改:
*   1. 类型 : 创建
*      作者 : 徐烁超
*      时间 : 2020.04.16
*      内容 : 创建函数
************************************************************************************************/
function mc_comparison_param_json(str_param_json_new, str_param_json_old) {
    if ("string" !== typeof str_param_json_new || 0 >= str_param_json_new.length) {
        return false;
    }
    if ("string" !== typeof str_param_json_old || 0 >= str_param_json_old.length) {
        return false;
    }
    var obj_param_new = new mc_sdk_param();
    var obj_param_old = new mc_sdk_param();

    if (!obj_param_new.set_json(str_param_json_new) || !obj_param_old.set_json(str_param_json_old)) {
        return false;
    }
    var ui_param_cnt = obj_param_new.get_param_cnt();

    for (var idx = 0; idx < ui_param_cnt; idx++) {
        var str_name = obj_param_new.get_param_name(idx);
        var str_val_new = obj_param_new.get_param_value(str_name);
        var str_val_old = obj_param_old.get_param_value(str_name);

        if (!str_val_new || !str_val_old || str_val_new !== str_val_old) {
            return false;
        }
    }
    return true;
}

